<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Validator;
use  App\Models\User;
use  App\Models\DefaultRolePrivilege;

class DefaultRolePrivilegeController extends Controller
{
     /**
     * Instantiate a new UserController instance. 
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * This function use for create the module
     *
     * @return Response
     */
    public function addDefaultRolePrivilege(Request $request){
        $validator = Validator::make($request->all(), [ 
            'role' => 'required',
            'module' => 'required',
            'privilege' => 'required',
        ]);
        if ($validator->fails()) { 
            $result = ['type'=>'error', 'message'=>$validator->errors()->all()];
            return response()->json($result);            
        }
        $user = Auth::user();
        $DefaultRolePrivilege = new DefaultRolePrivilege();
        $DefaultRolePrivilege->role = $request->role;
        $DefaultRolePrivilege->module = $request->module;
        $DefaultRolePrivilege->privilege = $request->privilege;
        $DefaultRolePrivilege->created_by = $user->admin_id;
        $DefaultRolePrivilege->updated_by = $user->admin_id;
        $DefaultRolePrivilege->save();
        
        return response()->json(['data' => $DefaultRolePrivilege, 'status' => 'success'], 200);
    }

    
    /**
     * This function use for update the module
     *
     * @return Response
     */
    public function updateDefaultRolePrivilege(Request $request, $id){
        $validator = Validator::make($request->all(), [ 
            'role' => 'required',
            'module' => 'required',
            'privilege' => 'required',
        ]);
        if ($validator->fails()) { 
            $result = ['type'=>'error', 'message'=>$validator->errors()->all()];
            return response()->json($result);            
        }
        $user = Auth::user();
        $DefaultRolePrivilege = DefaultRolePrivilege::where('default_role_p_id', $id)->first();
        if($DefaultRolePrivilege){
            $DefaultRolePrivilege->role = $request->role;
            $DefaultRolePrivilege->module = $request->module;
            $DefaultRolePrivilege->privilege = $request->privilege;
            $DefaultRolePrivilege->updated_by = $user->admin_id;
            $DefaultRolePrivilege->save();
            
            return response()->json(['data' => $DefaultRolePrivilege, 'status' => 'success'], 200);
        }else{
            return response()->json(['data' => '', 'status' => 'warning', 'message' => 'No Data Found!'], 201);
        }
        
    }

	/**
     * This function use for delete the DefaultRolePrivilege
     *
     * @return Response
     */
    public function inactiveDefaultRolePrivilege($id){
		$DefaultRolePrivilege = DefaultRolePrivilege::where('default_role_p_id', $id)->first();
		$DefaultRolePrivilege->enabled = 0;
        $DefaultRolePrivilege->save();
		return response()->json(['users' =>  DefaultRolePrivilege::all()], 200);
    }
	
	/**
     * This function use for delete the DefaultRolePrivilege
     *
     * @return Response
     */
    public function activeDefaultRolePrivilege($id){
        $DefaultRolePrivilege = DefaultRolePrivilege::where('default_role_p_id', $id)->first();
		$DefaultRolePrivilege->enabled = 1;
        $DefaultRolePrivilege->save();
		return response()->json(['users' =>  DefaultRolePrivilege::all()], 200);
    }

    /**
     * This function use for get the module
     *
     * @return Response
     */
    public function getDefaultRolePrivilege($id){
        
        $DefaultRolePrivilege = DefaultRolePrivilege::where('default_role_p_id', $id)->first();
        if($DefaultRolePrivilege){
            return response()->json(['data' => $DefaultRolePrivilege, 'status' => 'success'], 200);
        }else{
            return response()->json(['data' => '', 'status' => 'warning', 'message' => 'No Data Found!'], 201);
        }
    }

    /**
     * This function use for get all modules
     *
     * @return Response
     */
    public function getDefaultRolePrivileges(){
        $DefaultRolePrivileges = DefaultRolePrivilege::All();
        
        return response()->json(['data' => $DefaultRolePrivileges, 'status' => 'success'], 200);
    }

}