<?php

/** @var \Laravel\Lumen\Routing\Router $router */

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It is a breeze. Simply tell Lumen the URIs it should respond to
| and give it the Closure to call when that URI is requested.
|
*/

$router->get('/', function () use ($router) {
    return $router->app->version();
});

$router->group(['prefix' => 'api'], function () use ($router) {
        
     // Token Verify
    $router->post('tokenverify', 'AuthController@tokenVerify');

    // Add alert
    $router->post('addalert', 'UserAlertController@addAlert');
    $router->post('updatealert', 'UserAlertController@updateAlert');
    $router->get('getalerts', 'UserAlertController@getUserAlerts');
    $router->get('getalertscount', 'UserAlertController@getUserAlertsCount');
    $router->post('deletealert', 'UserAlertController@deleteAlert');

});
