<?php

/** @var \Laravel\Lumen\Routing\Router $router */

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It is a breeze. Simply tell Lumen the URIs it should respond to
| and give it the Closure to call when that URI is requested.
|
*/

$router->get('/', function () use ($router) {
    return $router->app->version();
});

$router->group(['prefix' => 'api'], function () use ($router) {
    // Matches "/api/register
    $router->post('register', 'AuthController@register');

     // Matches "/api/login
    $router->post('login', 'AuthController@login');
    
     // OTP Verify
    $router->post('otpverify', 'AuthController@otpVerify');


	// User Module
	$router->get('profile', 'UserController@profile');
	$router->get('users/{id}', 'UserController@singleUser');
	$router->get('users', 'UserController@allUsers');
	$router->get('useractive/{id}', 'UserController@activeUser');
	$router->get('userinactive/{id}', 'UserController@inactiveUser');
	$router->post('updateuser', 'UserController@updateUser');


    // Add module
    $router->post('addmodule', 'ModuleController@addModule');
    $router->post('updatemodule/{id}', 'ModuleController@updateModule');
    $router->get('inactivemodule/{id}', 'ModuleController@inactiveModule');
    $router->get('activemodule/{id}', 'ModuleController@activeModule');
    $router->get('getmodule/{id}', 'ModuleController@getModule');
    $router->get('getallmodules', 'ModuleController@getModules');

    // Role Module APIs
    $router->post('addrole', 'RoleController@addRole');
    $router->post('updaterole/{id}', 'RoleController@updateRole');
    $router->get('inactiverole/{id}', 'RoleController@inactiveRole');
    $router->get('activerole/{id}', 'RoleController@activeRole');
    $router->get('getrole/{id}', 'RoleController@getRole');
    $router->get('getallrole', 'RoleController@getRoles');

    // Privilege Module APIs
    $router->post('addprivilege', 'PrivilegeController@addPrivilege');
    $router->post('updateprivilege/{id}', 'PrivilegeController@updatePrivilege');
    $router->get('deleteprivilege/{id}', 'PrivilegeController@deletePrivilege');
    $router->get('getprivilege/{id}', 'PrivilegeController@getPrivilege');
    $router->get('getallprivileges', 'PrivilegeController@getPrivileges');

    // DefaultRolePrivilege Module APIs
    $router->post('adddefaultroleprivilege', 'DefaultRolePrivilegeController@addDefaultRolePrivilege');
    $router->post('updatedefaultroleprivilege/{id}', 'DefaultRolePrivilegeController@updateDefaultRolePrivilege');
    $router->get('inactivefaultroleprivilege/{id}', 'DefaultRolePrivilegeController@inactiveDefaultRolePrivilege');
    $router->get('activefaultroleprivilege/{id}', 'DefaultRolePrivilegeController@activeDefaultRolePrivilege');
    $router->get('getdefaultroleprivilege/{id}', 'DefaultRolePrivilegeController@getDefaultRolePrivilege');
    $router->get('getalldefaultroleprivileges', 'DefaultRolePrivilegeController@getDefaultRolePrivileges');

    // Admin Role Module APIs
    $router->post('addadminrole', 'AdminRoleController@addAdminRole');
    $router->post('updateadminrole/{id}', 'AdminRoleController@updateAdminRole');
    $router->get('deleteadminrole/{id}', 'AdminRoleController@deleteAdminRole');
    $router->get('activeadminrole/{id}', 'AdminRoleController@activeAdminRole');
    $router->get('getadminrole/{id}', 'AdminRoleController@getAdminRole');
    $router->get('getadminroles', 'AdminRoleController@getAdminRoles');
    $router->post('getuserpermission', 'AdminRoleController@getAdminPermissionByModule');
    $router->post('getusermodulespermission', 'AdminRoleController@getUserModulesPermission');

});
