<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use  App\Models\User;
use  App\Models\Admin;
use Illuminate\Support\Facades\Auth;

class AuthController extends Controller
{
    /**
     * Store a new user.
     *
     * @param  Request  $request
     * @return Response
     */
    public function register(Request $request)
    {
        
        //validate incoming request 
        $this->validate($request, [
            'fname' => 'required|string',
            'lname' => 'required|string',
            'email' => 'required|email|unique:admins',
            'mobile' => 'required|unique:admins',
            'device_id' => 'required',
            'device_type' => 'required',
        ]);

        try {
                
            $user = new Admin;
            $user->first_name = $request->input('fname');
            $user->last_name = $request->input('lname');
            $user->email = $request->input('email');
            $user->mobile = $request->input('mobile');
            $user->device_id = $request->input('device_id');
            $user->device_type = $request->input('device_type');
            $user->created_by = $request->input('created_by');
            $user->updated_by = $request->input('updated_by');
            $user->auth_token = 1;

            $user->save();

            //return successful response
            return response()->json(['user' => $user, 'message' => 'CREATED'], 201);

        } catch (\Exception $e) {
            //return error message
            //dd($e);
            return response()->json(['message' => 'User Registration Failed!'], 409);
        }

    }
    
    /**
     * Get a JWT via given credentials.
     *
     * @param  Request  $request
     * @return Response
     */
    public function login(Request $request)
    {
          //validate incoming request 
        $this->validate($request, [
            'mobile' => 'required'
        ]);

        $otp = str_pad(rand(0, pow(10, 4)-1), 4, '0', STR_PAD_LEFT);
        
        $admin_detaile = Admin::where('mobile', $request->input('mobile'))->first();
        $admin_detaile->password = app('hash')->make($otp);
        $admin_detaile->save();

        
        return response()->json(['message' => 'User Verify', 'otp' => $otp, 'mobile' => $admin_detaile->mobile], 200);
        
    }

     /**
     * Get a JWT via given credentials.
     *
     * @param  Request  $request
     * @return Response
     */
    public function otpVerify(Request $request)
    {
        //validate incoming request 
        $this->validate($request, [
            'mobile' => 'required',
            'password' => 'required',
        ]);
		
        $credentials = $request->only(['mobile', 'password']);

        if (! $token = Auth::attempt($credentials)) {
            return response()->json(['message' => 'Unauthorized'], 401);
        }

        return $this->respondWithToken($token);
    }


}