<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Validator;
use App\Models\User;
use App\Models\AdminRole;
use App\Models\DefaultRolePrivilege;

class AdminRoleController extends Controller
{
    /**
     * Instantiate a new UserController instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * This function use for create the AdminRole
     *
     * @return Response
     */
    public function addAdminRole(Request $request){
        $validator = Validator::make($request->all(), [ 
            'admin_id' => 'required',
            'role_id' => 'required',
        ]);
        if ($validator->fails()) { 
            $result = ['type'=>'error', 'message'=>$validator->errors()->all()];
            return response()->json($result);            
        }
        AdminRole::where('admin_id', $request->admin_id)->delete();
        $user = Auth::user();
        $default_role_menus = DefaultRolePrivilege::where('role', $request->role_id)->get();
        foreach($default_role_menus as $default_role_menu){
            $AdminRole = new AdminRole();
            $AdminRole->admin_id = $request->admin_id;
            $AdminRole->role_id = $request->role_id;
            $AdminRole->module_id = $default_role_menu->module;
            $AdminRole->privilege_id = $default_role_menu->privilege;
            $AdminRole->created_by = $user->admin_id;
            $AdminRole->updated_by = $user->admin_id;
            $AdminRole->save();
        }
        $AdminRoles = AdminRole::where('admin_id', $request->admin_id)->get();
        return response()->json(['data' => $AdminRoles, 'status' => 'success'], 200);
    }

    
    /**
     * This function use for update the module
     *
     * @return Response
     */
    public function updateAdminRole(Request $request, $id){
        $validator = Validator::make($request->all(), [ 
            'privilege_id' => 'required',
        ]);
        if ($validator->fails()) { 
            $result = ['type'=>'error', 'message'=>$validator->errors()->all()];
            return response()->json($result);            
        }
        $user = Auth::user();
        $AdminRole = AdminRole::where('role_map_id', $id)->first();
        $AdminRole->privilege_id = $request->privilege_id;
        $AdminRole->updated_by = $user->admin_id;
        $AdminRole->save();
        
        return response()->json(['data' => $AdminRole, 'status' => 'success'], 200);
    }

    /**
     * This function use for delete the module
     *
     * @return Response
     */
    public function deleteAdminRole($id){
        $AdminRole = AdminRole::where('role_map_id', $id)->first();
        $AdminRole->status = 0;
        $AdminRole->save();
        $AdminRoles = AdminRole::All();
        return response()->json(['data' => $AdminRoles, 'status' => 'success'], 200);
    }
    
    
    /**
     * This function use for active the module
     *
     * @return Response
     */
    public function activeAdminRole($id){
        $AdminRole = AdminRole::where('role_map_id', $id)->first();
        $AdminRole->status = 1;
        $AdminRole->save();
        $AdminRoles = AdminRole::All();
        return response()->json(['data' => $AdminRoles, 'status' => 'success'], 200);
    }

    /**
     * This function use for get the module
     *
     * @return Response
     */
    public function getAdminRole($id){
        
        $AdminRole = AdminRole::where('role_map_id', $id)->first();
        
        return response()->json(['data' => $AdminRole, 'status' => 'success'], 200);
    }

    /**
     * This function use for get all modules
     *
     * @return Response
     */
    public function getAdminRoles(){
        $AdminRoles = AdminRole::All();
        
        return response()->json(['data' => $AdminRoles, 'status' => 'success'], 200);
    }
	
	
	/**
     * This function use for get admin permission by module
     *
     * @return Response
     */
    public function getAdminPermissionByModule(Request $request){
        
		$this->validate($request, [
			'user_id' => 'required',
            'module_id' => 'required',
		]);
		
		try{
			$userper = AdminRole::where('admin_id', $request->user_id)->where('module_id', $request->module_id)->with('getRoleDetails')->with('getModuleDetails')->with('getPrivilegeDetails')->get();
        
			return response()->json(['data' => $userper, 'status' => 'success'], 200);
		}catch(Exseption $e){
			return response()->json(['error' => $e->getMessage()]);
		}
    }
	
	/**
     * This function use for get user permission for all modules
     *
     * @return Response
     */
    public function getUserModulesPermission(Request $request){
        
		$this->validate($request, [
			'user_id' => 'required',
		]);
		
		try{
			$userper = AdminRole::where('admin_id', $request->user_id)->with('getRoleDetails')->with('getModuleDetails')->with('getPrivilegeDetails')->get();
			
			if($userper->count() > 0){
			    $user_role = $userper[0]->getRoleDetails->role_name;
    			$user_id = $userper[0]->admin_id;
    			$array_data = [];
    			foreach($userper as $user){
    				$array_data[] = array('module' => $user->getModuleDetails->module_name, 'privilege' => $user->getPrivilegeDetails->name);
    			}
    			$data = array('admin_id' => $user_id, 'role' => $user_role, 'modules_privileges' => $array_data);
    			return response()->json(['data' => $data, 'status' => 'success'], 200);
			}else{
			    //return response()->json(['data' => '', 'status' => 'true', 'message' => 'Data Not Found!'], 404);
			    return response()->json([], 200);
			}
			
		}catch(Exseption $e){
			return response()->json(['error' => $e->getMessage()]);
		}
    }

}